/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com				
*/

var STBGlobalFormsSelect = Object.create(STBModule.prototype);

STBGlobalFormsSelect.name = "GlobalFormsSelect";
STBGlobalFormsSelect.initOneTime = function() {
	//on change select redirect
	jQuery("select[data-click=true]").on(
		'change', 
		function() {
			window.location.href = jQuery(this).find("option:selected").attr("data-link")
		}
	);
}

STBGlobalFormsSelect.initEveryTime = function() {

		var elements = null;

		//default select on selects
		elements = jQuery("select[data-selected]:not(.__done)");

		if (elements.length){
			elements.each(function () {
				var obj = jQuery(this);
				obj.val(obj.attr("data-selected"));

				if (obj.data("chosen")) {
					obj.chosen.trigger("update");
				}

				//obj.addClass("__done");
			});
		}

		//initialise chosen plugin
		elements = jQuery('select:not(.__done)');

		if (elements.length){
			elements.chosen({
	            disable_search_threshold: 10,
				allow_single_deselect: true
	        });

			elements.addClass("__done");
		}
}


STBGlobalFormsSelect.runOnReady = function() {
	STBGlobalFormsSelect.initOneTime();
	STBGlobalFormsSelect.initEveryTime();
}

STBGlobalFormsSelect.runOnContentUpdate = function() {
		STBGlobalFormsSelect.initEveryTime();

}

site.registerModule(STBGlobalFormsSelect);
